<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property mixed admin_read
 * @property mixed is_read
 * @mixin  Builder
 */
class UsersNotification extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'title',
        'message',
//        'user_id',
//        'service_id',
//        'notification_type',
//        'send_to',
        'is_read',
        'is_seen',
        'admin_read',
    ];

    protected $casts = ['is_read' => 'array', 'is_seen' => 'array', 'title' => 'array', 'message' => 'array'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
