<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Category
 * @package App
 * @mixin Builder
 */
class Tag extends Model
{
    // For soft delete
    use SoftDeletes;

    protected $fillable = ['status'];

    /**
     * Get the description of the tag.
     * @param int $language_id
     * @return HasMany
     */
    public function descriptions($language_id= 0) :HasMany
    {
        if ($language_id) {
            return $this->hasMany(TagDescription::class)->where('language_id', $language_id);
        }
        return $this->hasMany(TagDescription::class);
    }


    public static function withDescription($type = null, $limit = null)
    {
        $tag = self::join('tag_descriptions as sd', 'sd.tag_id', 'tags.id')
            ->where('sd.language_id', currentLanguage()->id);

        if($type) {
            $tag->whereType($type);
        }

        if ($limit){
            $tag->limit($limit);
        }

        return $tag->select(['sd.name', 'tags.*'])->cursor() ?? [];
    }

}
