<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Slider
 * @package App
 * @mixin Builder
 */
class SiteSlider extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'button_url',
        'image',
    ];


    public static function withDescription($ids = [], $notIn = [])
    {
        $query = self::join('site_slider_descriptions as sDesc', 'sDesc.site_slider_id', 'site_sliders.id')
            ->where('sDesc.language_id', currentLanguage()->id);

        if (count($ids)){
            $query->whereIn('site_sliders.id', $ids);
        }

        if (count($notIn)){
            $query->whereNotIn('site_sliders.id', $notIn);
        }

        $query->select(['site_sliders.image', 'site_sliders.button_url', 'sDesc.title', 'sDesc.button_title',  'sDesc.description']);

        return count($ids) == 1 ? $query->first() : $query->cursor();
    }

}
