<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property mixed branch_ids
 * @property mixed main_section
 * @property mixed sub_sections
 * @property mixed durations
 * @property mixed id
 * @mixin Builder
 */
class Service extends Model
{
    use SoftDeletes;

    protected $fillable = ['image'];


    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(ServiceDescription::class);
    }


    public function descriptionFetch($language_id= null)
    {

        if ($language_id) {
            $data = $this->hasMany(ServiceDescription::class)->where('language_id', $language_id)->first();
            if(!$data){
                $data = $this->hasMany(ServiceDescription::class)->first();
            }

            return $data;
        }
        $data = $this->hasMany(ServiceDescription::class)->where('language_id', currentLanguage()['id'])->first();
        return $data;
    }

    /**
     * Get description of current language for pages
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(ServiceDescription::class)->where('language_id', currentLanguage()->id);
    }

    public static function withDescription($ids = [], $limit = null, $random = false, $hasRelation = null)
    {
        $query = self::orderByDesc('services.id')->join('service_descriptions as sDesc', 'sDesc.service_id', 'services.id')
            ->where('sDesc.language_id', currentLanguage()->id);

        if ($hasRelation){
            $query->whereHas($hasRelation);
        }
        if (count($ids)){
            $query->whereIn('services.id', $ids);
        }

        if ($limit){
            $query->limit($limit);
        }

        if ($random){
          $query->inRandomOrder();
        }

        $query->select([
            'services.*',
            'sDesc.name',
        ]);

        return $query;
    }

    public function appointments()
    {
        return $this->hasMany(Appointment::class);
    }

    public function evaluates()
    {
        return $this->hasMany(Evaluate::class);
    }


}
