<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Review
 * @package App
 *@mixin Builder
 */
class Review extends Model
{
    use SoftDeletes;

    protected $fillable = ['rate', 'image', 'status'];

    public static function withDescription()
    {
        $query = self::orderBy('reviews.id', 'DESC')
            ->join('review_descriptions as rDesc', 'rDesc.review_id', 'reviews.id')
            ->where('rDesc.language_id', currentLanguage()->id)
            ->select(['reviews.created_at', 'rDesc.*']);

        $query->select([
            'reviews.rate',
            'rDesc.name',
            'rDesc.review',
        ]);

        return $query->cursor();
    }

}
