<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Reservation
 * @package App
 * @mixin Builder
 */
class Reservation extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'phone',
        'email',
        'durations',
        'user_id',
        'service_id',
        'branch_id',
        'doctor_id',
        'appointment_date',
        'appointment_time',
        'status',
        'evaluate_token',
        'updated_calendar'
    ];
}
