<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;


class Project extends Model
{
    use SoftDeletes;

    protected $fillable = ['image'];


    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(ProjectDescription::class);
    }



    /**
     * Get description of current language for pages
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(ProjectDescription::class)->where('language_id', currentLanguage()->id);
    }

    public static function withDescription($ids = [], $limit = null, $random = false, $hasRelation = null)
    {
        $query = self::orderByDesc('projects.id')->join('project_descriptions as pDesc', 'pDesc.service_id', 'projects.id')
            ->where('pDesc.language_id', currentLanguage()->id);

        if ($hasRelation){
            $query->whereHas($hasRelation);
        }
        if (count($ids)){
            $query->whereIn('projects.id', $ids);
        }

        if ($limit){
            $query->limit($limit);
        }

        if ($random){
            $query->inRandomOrder();
        }

        $query->select([
            'projects.*',
            'pDesc.name',
        ]);

        return $query;
    }


}
