<?php

namespace App\Http\Resources;

use App\Helpers\ImageHelper;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @property mixed image
 * @property mixed description
 * @property mixed title
 */
class VisionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'image' => ImageHelper::getFullPath($this->image),
            'title' => $this->title,
            'description' => stripText($this->description),
        ];
    }
}
