<?php

namespace App\Http\Resources;

use App\Helpers\ImageHelper;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @property mixed id
 * @property mixed type
 * @property mixed service_id
 * @property mixed title
 * @property mixed description
 * @property mixed image
 * @property mixed url
 */
class SliderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'service_id' => $this->service_id,
            'title' => $this->title,
            'description' => stripText($this->description),
            'image' => ImageHelper::getFullPath($this->image),
            'url' => $this->url,
        ];
    }
}
