<?php

namespace App\Http\Resources;

use App\Helpers\ImageHelper;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @property mixed sub_sections
 * @property mixed name
 * @property mixed main_section
 * @property mixed durations
 * @property mixed image
 * @property mixed id
 */
class ServiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request)
    {

        $subSections = [];
        $local = getCurrentLocale();

        foreach ($this->sub_sections as $sub_section) {
            $subSections[] = [
                'image' => ImageHelper::getFullPath($sub_section['image']),
                'title' => $sub_section['title_'.$local],
                'description' => $sub_section['desc_'.$local],
            ];
        }

        return [
            'id' => $this->id,
            'durations' => $this->durations,
            'name' => $this->name,
            'image' => ImageHelper::getFullPath($this->image),
            'description' => $this->main_section['desc_'.$local],
            'service_sliders' => $this->main_section['sliders'],
            'sub_sections' => $subSections,
        ];
    }
}
