<?php

namespace App\Http\Resources;

use App\Helpers\ImageHelper;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;


/**
 * @property mixed image
 * @property mixed video_url
 * @property mixed title
 * @property mixed type
 */
class GalleryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'type' => $this->type,
            'image' => ImageHelper::getFullPath($this->image),
            'video_url' => $this->video_url,
            'title' => $this->title,
        ];
    }
}
