<?php

namespace App\Http\Resources;

use App\Helpers\ImageHelper;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @property mixed about_title
 * @property mixed about_description
 * @property mixed images
 * @property mixed title
 * @property mixed description
 */
class AboutsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'image' => ImageHelper::getFullPath($this->images['about_image']),
            'title' => $this->title,
            'description' => stripText($this->description),
        ];
    }
}
