<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

/**
 * @property mixed symbol
 */
class WorkHourRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (! Auth::check()) {
            return false;
        }
        if(Auth::user()->role == 'admin' )
        {
            return true;
        }

        if(Auth::user()->hasModule( 'workHours' ) )
        {
            return true;
        }
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [];
        foreach (languages() as $lang) {
            $lang_rules = [];
            $lang_rules['home_page_work_time_'.$lang->local] = 'required|min:3';
            $rules= array_merge($rules, $lang_rules);

        }

        $rules['contact_us_work_time.*'] = 'required|min:3';

        return $rules;
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        $field = metaFields('workHours');
        $local = getCurrentLocale();
        $attributes=[];
        foreach (languages() as $lang) {
            $local = $lang->local == 'ar' ? ' (عربي) ' : ' (English) ';
            $lang_attributes=[
                'title_'.$lang->local => ($field[$lang->local]['title'] ?? __('workHours.title')) . $local,
                'brief_'.$lang->local => ($field[$lang->local]['brief'] ?? __('workHours.brief')) . $local,
                'home_page_work_time_'.$lang->local=> ($field[$lang->local]['home_page_work_time'] ?? __('workHours.home_page_work_time')).$local,
            ];
            $attributes= array_merge($attributes, $lang_attributes);
        }
        return $attributes;
    }

    public function messages()
    {
        return [
            'contact_us_work_time.*.required' => __('workHours.all_days_work_hours_required')
        ];
    }

    /**
     * Handle a failed validation attempt.
     *
     * Override the parent method action if the request is for AJAX
     *
     * @param Validator $validator
     * @return void
     *
     * @throws ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
        // Change response attitude if the request done via Ajax requests like API requests
        if(Request::wantsJson()){
            $errors = (new ValidationException($validator))->errors();
            throw new HttpResponseException(response()->json(['errors' => $errors], 422));
        } elseif (Request::ajax()){
            $errors = $validator->errors()->first();
            throw new HttpResponseException(response()->json(['errors' => $errors]));
        } else {
            parent::failedValidation($validator);
        }
    }
}
