<?php

namespace App\Http\Requests\Web;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Request;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class VisitorMessageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     * So the user must be guest
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $phonePattern = '/^(5){1}([0-9]{8})$/';
        $namesRegex = '/^([a-zA-Z ]|[\p{Arabic}])*$/u';

        $rules = [
            'name'     => ['required', 'min:3', 'max:100', "regex:$namesRegex"],
            'email'     => ['required', 'email', 'min:3', 'max:100'],
            'phone'=> [
                "required",
                "numeric",
                "regex:".$phonePattern,
            ],

//            'subject'     => ['required', 'min:3', 'max:100'],
            'message'     => ['required', 'min:3', 'max:300'],
        ];
        return $rules;
    }

    public function attributes()
    {
        $field = metaFields('visitorMessages');
        $local = getCurrentLocale();
        $attributes = [
            'name' => $field[$local]['name'] ?? __('visitorMessages.name'),
            'email' => $field[$local]['email'] ?? __('visitorMessages.email'),
            'phone' => $field[$local]['phone'] ?? __('visitorMessages.phone'),
            'subject' => $field[$local]['subject'] ?? __('visitorMessages.subject'),
            'message' => $field[$local]['message'] ?? __('visitorMessages.message'),
        ];

        return $attributes;
    }


    public function messages()
    {
        return [
            'phone.digits' => __('visitorMessages.phone_digits'),
            'name.regex' => __('visitorMessages.names_accepted_chars_only'),
        ];
    }


    /**
     * Handle a failed validation attempt.
     *
     * Override the parent method action if the request is for AJAX
     *
     * @param Validator $validator
     * @return void
     *
     * @throws ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
    	// Change response attitude if the request done via Ajax requests like API requests

    	if(Request::ajax()){
	        $errors = $validator->errors()->first();
	        throw new HttpResponseException(response()->json(['errors' => $errors]));
	    } else {
	    	// Do the original action of the Form request class
	    	parent::failedValidation($validator);
	    }
    }
}
