<?php

namespace App\Http\Requests\Web;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Request;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class RoomEvaluateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     * So the user must be guest
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $namesRegex = '/^([a-zA-Z ]|[\p{Arabic}])*$/u';
        $evalRegex = '/^[1-5]{1}$/';
        $rules = [
            'reception_evaluation' => ['required', 'regex:'.$evalRegex],
            'safety_evaluation' => ['required', 'regex:'.$evalRegex],
            'room_evaluation' => ['required', 'regex:'.$evalRegex],
            'food_evaluation' => ['required', 'regex:'.$evalRegex],
            'name' => ['required', 'min:3', 'max:100', "regex:$namesRegex"],
            'evaluate_text' => 'required|min:3|max:300',
        ];
        return $rules;
    }

    public function attributes()
    {
        $field = metaFields('roomEvaluates');
        $local = getCurrentLocale();
        $attributes = [
            'reception_evaluation' => $field[$local]['reception_evaluation'] ?? __('roomEvaluates.reception_evaluation'),
            'safety_evaluation' => $field[$local]['safety_evaluation'] ?? __('roomEvaluates.safety_evaluation'),
            'room_evaluation' => $field[$local]['room_evaluation'] ?? __('roomEvaluates.room_evaluation'),
            'food_evaluation' => $field[$local]['food_evaluation'] ?? __('roomEvaluates.food_evaluation'),
            'name' => $field[$local]['name'] ?? __('roomEvaluates.name'),
            'evaluate_text' => $field[$local]['evaluate_text'] ?? __('roomEvaluates.evaluate_text'),
        ];

        return $attributes;
    }


    /**
     * Handle a failed validation attempt.
     *
     * Override the parent method action if the request is for AJAX
     *
     * @param Validator $validator
     * @return void
     *
     * @throws ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
        // Change response attitude if the request done via Ajax requests like API requests

        if(Request::ajax()){
            $errors = $validator->errors()->first();
            throw new HttpResponseException(response()->json(['errors' => $errors]));
        } else {
            // Do the original action of the Form request class
            parent::failedValidation($validator);
        }
    }
}
