<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class LanguageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
		    'local' => [
		    	"required", "max:2",
		    	Rule::unique('languages')->ignore($this->id? $this->id : 0)
		    ],
		    'name' => [
		    	"required",
		    	Rule::unique('languages')->ignore($this->id? $this->id : 0)
		    ],
	    ];
    }

    /**
     * Handle a failed validation attempt.
     *
     * Override the parent method action if the request is for AJAX
     *
     * @param  \Illuminate\Contracts\Validation\Validator  $validator
     * @return void
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
    	// Change response attidude if the request done via Ajax requests like API requests

    	if(\Request::wantsJson()){
	        $errors = (new ValidationException($validator))->errors();
	        throw new HttpResponseException(response()->json(['errors' => $errors], 422));
	    } else {
	    	// Do the original action of the Form request class
	    	parent::failedValidation($validator);
	    }
    }
}
