<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

/**
 * @property mixed type
 * @property mixed video_url
 * @property mixed image
 * @property mixed file
 */
class AppSliderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (! Auth::check()) {
            return false;
        }
        if(in_array(Auth::user()->role, ['super_admin', 'admin', 'sub_admin']))
        {
            return true;
        }

        if(Auth::user()->hasModule('appSliders'))
        {
            return true;
        }
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        $rules = [
            'type' => 'required|in:image_only,image_service,image_external_url',
            'service_id' => 'required_if:type,image_service|nullable|exists:services,id',
            'url' => 'required_if:type,image_external_url|nullable|url|max:200',
        ];

        foreach (languages() as $lang) {
            $lang_rules=[
                'title_'.$lang->local=> 'required|min:3|max:100',
                'description_'.$lang->local=> 'required|min:3',
            ];

            $rules= array_merge($rules, $lang_rules);

        }


//        foreach (languages() as $lang) {
//            $lang_rules=[
//                "title_$lang->local" => 'required_if:type,video_type|nullable|min:3|max:100',
//            ];
//            $rules= array_merge($rules, $lang_rules);
//        }

//        $allowedFiles = ['.pdf', '.jpg', '.jpeg', '.png'];
//
//        $image = request('image');
//
//        $isValid = false;
//
//        foreach ($allowedFiles as $allowedFile) {
//            if (strpos($image, $allowedFile)){
//                $isValid = true;
//                break;
//            }
//        }
//
//        if (!$isValid){
//            $rules['image_validate'] = 'required';
//        }

        $rules['image'] = 'required';

        return $rules;
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        $field = metaFields('appSliders');
        $local = getCurrentLocale();
        $attributes=[
            'type' => $field[$local]['type'] ?? __('appSliders.type'),
            'service_id' => $field[$local]['video_url'] ?? __('appSliders.video_url'),
            'url' => $field[$local]['video_url'] ?? __('appSliders.video_url'),
            'image' => $field[$local]['image'] ?? __('appSliders.image'),
        ];


        foreach (languages() as $lang) {
            $local = $lang->local == 'ar' ? ' (عربي) ' : ' (English) ';
            $lang_attributes=[
                'title_'.$lang->local => ($field[$lang->local]['title'] ?? __('appSliders.title')) . $local,
                'description_'.$lang->local => ($field[$lang->local]['description'] ?? __('appSliders.description')) . $local,
            ];
            $attributes= array_merge($attributes, $lang_attributes);
        }
        return $attributes;
    }


    public function messages()
    {
        $attributes = [
            'url.required_if' => __('appSliders.url_required'),
            'service_id.required_if' => __('appSliders.service_id_required'),
        ];

//        foreach (languages() as $lang) {
//            $lang_attributes=[
//                'title_'.$lang->local.'.required_if' => __('appSliders.title_required_if'),
//            ];
//            $attributes= array_merge($attributes, $lang_attributes);
//        }
        return $attributes;
    }


    /**
     * Handle a failed validation attempt.
     *
     * Override the parent method action if the request is for AJAX
     *
     * @param Validator $validator
     * @return void
     *
     * @throws ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
        // Change response attitude if the request done via Ajax requests like API requests
        if(Request::wantsJson()){
            $errors = (new ValidationException($validator))->errors();
            throw new HttpResponseException(response()->json(['errors' => $errors], 422));
        } elseif (Request::ajax()){
            $errors = $validator->errors()->first();
            throw new HttpResponseException(response()->json(['errors' => $errors]));
        } else {
            parent::failedValidation($validator);
        }
    }}
