<?php

namespace App\Http\Middleware;

use App\Providers\RouteServiceProvider;
use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        if (Auth::guard($guard)->check()) {
            if(Route::currentRouteName() == 'superAdminLogin'){
                Auth::logout();
                return redirect(url()->current());
            }
            if (Auth::user()->admin_token){
                return redirect(RouteServiceProvider::ADMIN);
            }
            return redirect(RouteServiceProvider::HOME);
        }

        return $next($request);
    }
}
