<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Reservation;
use App\Service;
use Illuminate\View\View;

class ServiceController extends Controller
{

    private $view = 'web.services.';
    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {
        $title = __('services.our_medical_services');
        $services = Service::withDescription()->paginate(6);
        return view($this->view.'index', get_defined_vars());
    }

    public function show(Service $service)
    {
        $service = Service::withDescription([$service->id])->first();
        $title = $service->name;
        $title1 = wordLimit($title, 1, '');
        $title2 = str_replace($title1, '', $title);
        return view($this->view.'show', get_defined_vars());
    }

}
