<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Page;
use Illuminate\View\View;

class PageController extends Controller
{
    private $view = 'web.pages.';

    private $pages;

    public function __construct()
    {
        $this->pages = Page::withDescription([5,6])->toArray();
    }

    /**
     * Show the application dashboard.
     * @param $type
     * @return View
     */

    public function index($type)
    {
        $types = ['terms-condition','evacuation-responsibilaty'];

        if (!in_array($type, $types)){
            abort(404);
        }

        $pageIndex = array_search($type, $types);
        $page = $this->pages[$pageIndex];
        $title = $page['title'];
        return view($this->view.'index', get_defined_vars());
    }

}
