<?php


namespace App\Http\Controllers\Web;

use App\Helpers\QrCode;
use App\Jobs\SendBillJob;
use App\Payment;
use Illuminate\Http\Request;

class MyFatoorah
{

    private static $apiKey;
    private static $apiURL;
    private $API_KEY;
    private $API_URL;


    public function __construct()
    {
        $this->API_KEY = env('MY_FATOORA_TOKEN');
        $this->API_URL = env('MY_FATOORA_URL');
        self::$apiKey = $this->API_KEY;
        self::$apiURL = $this->API_URL;
    }

    public static function pay()
    {
        $token = bcrypt(rand(11111,9999).time());
        $roomReservation = session('room_reservation');

        $check = self::checkApi($token);
        
        if(($check['errors'] ?? null)) {
            return ['errors' => $check['errors']];
        }
        Payment::create([
            'room_reservation_id' => $roomReservation['id'],
            'room_id' => $roomReservation['room_id'],
            'branch_id' => $roomReservation['branch_id'],
            'room_type_id' => $roomReservation['room_type_id'],
            'amount' => $roomReservation['total'],
            'token' => $token,
            'meta' => ['payment_link' => $check['paymentLink']],

        ]);
        return ['errors' => false, 'url' => $check['paymentLink']];
    }

    private static function checkApi($token){
        $roomReservation = session('room_reservation');
        $username = $roomReservation['name'];
        $phone = $roomReservation['phone'];
        $email = $roomReservation['email'];


        $invoiceItems[] = [
            'ItemName'  => __('roomReservations.head'),
            'Quantity'  => 1,
            'UnitPrice' => $roomReservation['total'],
        ];

        $InvoiceValue = $roomReservation['total'];

        $paymentMethodId = $roomReservation['pay_way_api'];
        $callBackUrl = route('callback'); //route('callback');
        $postFields = [
            'CustomerName' => $username,
            'DisplayCurrencyIso' => 'SAR',
            'InvoiceAmount' => '000',
            'CurrencyIso' => 'SAR',
            'CustomerMobile' => $phone,
            'CustomerEmail' => $email,
            'paymentMethodId' => $paymentMethodId,
            'InvoiceValue'    => $InvoiceValue,
            'InvoiceItems'    => $invoiceItems,
            'UserDefinedField' => json_encode(['token' => $token]),
            'CallBackUrl'     => $callBackUrl,
            'ApiCustomFields' => 'token='.$token,
        ];

        $data = self::executePayment(env('MY_FATOORA_URL'), env('MY_FATOORA_TOKEN'), $postFields);

        // If errors found while execute payment
        if (is_array($data) && ($data['errors'] ?? null) ){
            return $data['errors'];
        }

        $paymentId = $data->InvoiceId;
        $paymentLink = $data->PaymentURL;
        return ['$paymentId' => $paymentId, 'paymentLink' => $paymentLink, 'success' => true];
    }

    private function initiatePayment($apiURL, $apiKey, $postFields) {

        $json = $this->callAPI("$apiURL/v2/InitiatePayment", $apiKey, $postFields);
        return $json->Data->PaymentMethods;
    }

    private static function executePayment($apiURL, $apiKey, $postFields) {

        $json = self::callAPI("$apiURL/v2/ExecutePayment", $apiKey, $postFields);
        // If errors found in call api
        if (is_array($json) && ($json['errors'] ?? null)){
            return $json;
        }
        return $json->Data;
    }

    private static function callAPI($endpointURL, $apiKey, $postFields = [], $requestType = 'POST') {

        $curl = curl_init($endpointURL);
        curl_setopt_array($curl, array(
            CURLOPT_CUSTOMREQUEST  => $requestType,
            CURLOPT_POSTFIELDS     => json_encode($postFields),
            CURLOPT_HTTPHEADER     => array("Authorization: Bearer $apiKey", 'Content-Type: application/json'),
            CURLOPT_RETURNTRANSFER => true,
        ));

        $response = curl_exec($curl);
        $curlErr  = curl_error($curl);

        curl_close($curl);

        if ($curlErr) {
            //Curl is not working in your server
            return $curlErr;
        }

        $error = self::handleError($response);
        if ($error) {
            return $error;
        }

        return json_decode($response);
    }

    public static function handleError($response) {

        $json = json_decode($response);
        if (isset($json->IsSuccess) && $json->IsSuccess == true) {
            return null;
        }

        //Check for the errors
        if (isset($json->ValidationErrors) || isset($json->FieldsErrors)) {
            $errorsObj = isset($json->ValidationErrors) ? $json->ValidationErrors : $json->FieldsErrors;
            $blogDatas = array_column($errorsObj, 'Error', 'Name');

            $error = implode(', ', array_map(function ($k, $v) {
                return "$k: $v";
            }, array_keys($blogDatas), array_values($blogDatas)));
        } else if (isset($json->Data->ErrorMessage)) {
            $error = $json->Data->ErrorMessage;
        }

        if (empty($error)) {
            $error = (isset($json->Message)) ? $json->Message : (!empty($response) ? $response : 'API key or API URL is not correct');
        }

        return ['errors' => $error];

    }

    public function callback(Request $request)
    {
        $keyId = $request->query('paymentId');
        $KeyType = 'paymentId';

        if (!$keyId){
            return redirect()->route('home')->with('alert_pop_up', __('main.payment_error'));
        }

        $postFields = [
            'Key'     => $keyId,
            'KeyType' => $KeyType,
        ];

        $curl = curl_init(env('MY_FATOORA_URL')."/v2/getPaymentStatus");
        curl_setopt_array($curl, array(
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => json_encode($postFields),
            CURLOPT_HTTPHEADER     => array("Authorization: Bearer ".env('MY_FATOORA_TOKEN'), 'Content-Type: application/json'),
            CURLOPT_RETURNTRANSFER => true,
        ));

        $response = curl_exec($curl);
        $curlErr  = curl_error($curl);

        curl_close($curl);

        if ($curlErr) {
            return ['errors' => $curlErr];
        }

        $error = $this->handleError($response);
        if ($error) {
            return ['errors' => $error];
        }

        $response = json_decode($response);
        $payment = null;
        if ($response->IsSuccess == true){
            $token = json_decode($response->Data->UserDefinedField)->token;
            $payment = Payment::where('token', $token);
            if (
                $response->Data->InvoiceStatus != 'Paid' &&
                $response->Data->InvoiceTransactions[0]->TransactionStatus != 'Succss'
            ) {
                $response->payment_url = $payment->first()->meta['payment_link'];
                $payment->update([
                    'meta' => json_encode($response),
                    'invoice_id' => $response->Data->InvoiceId,
                ]);
                return redirect()->route('home')->with('error_message', __('main.payment_failed'));
            }

        } else {
            return redirect()->route('home')->with('error_message', __('main.payment_failed'));
        }

        $payment = $payment->first();
        $response->token = $token;
        $complete = $this->completePay($response, $payment);
        if ($complete){
            session()->flash('success_message', __('main.payment_success'));
            session()->forget(['room_reservation']);
            return redirect()->route('home');
        }


    }

    private function completePay($response, $payment)
    {
        $payment->update([
            'meta' => json_encode($response), // ->Data->InvoiceTransactions[0]
            'invoice_id' => $response->Data->InvoiceId,
            'status' => 1
        ]);

        $roomReservation = session('room_reservation');

        $seller = settings('website_name_'.getCurrentLocale());
        $invoiceDate = $roomReservation['created_at'];
        $invoiceTotalAmount = $roomReservation['total'];
        $addedValue = settings('added_value');
        $invoiceTaxAmount = ($invoiceTotalAmount*$addedValue)/100;

        $qrCode = QrCode::generate($seller, $invoiceDate, $invoiceTotalAmount, $invoiceTaxAmount);

        try{
            SendBillJob::dispatch([
                'email'=> $roomReservation['email'],
                'reservation'=> $roomReservation,
                'qr_code'=> $qrCode['qr_code'],
            ], 'web.rooms.emails.send_bill');

        } catch (\Exception $e){}

        return true;
    }

}
