<?php

namespace App\Http\Controllers\Web;

use App\Branch;
use App\Category;
use App\Gallery;
use App\Http\Controllers\Controller;
use App\Page;
use App\Partner;
use App\Room;
use App\RoomEvaluate;
use App\RoomType;
use App\SiteSlider;
use App\WorkHour;
use Illuminate\Http\Request;
use Illuminate\View\View;


class ImageVideoGalleryController extends Controller
{
    private $view = 'web.video_image_galleries.';

    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {
        $title = __('galleries.head');

        $imagesGalleries = Gallery::withDescription('image_type')->groupBy('catName');
        $videoGalleries = Gallery::withDescription('video_type')->groupBy('catName');

        return view($this->view.'index', get_defined_vars());
    }

}
