<?php

namespace App\Http\Controllers\Web;

use App\Evaluate;
use Illuminate\Support\Facades\Session;
use App\Branch;
use App\Doctor;
use App\Gallery;
use App\Http\Controllers\Controller;
use App\Page;
use App\Review;
use App\Service;
use App\SiteSlider;
use App\WorkHour;
use App\Reservation;
use Illuminate\Http\Request;
use App\Helpers\GoogleCalenderApi;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;


class HomeController extends Controller
{
    private $view = 'web.home.';

    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {
        $title = __('main.home');


        $sliders = SiteSlider::withDescription();
        $pages = Page::withDescription([1,2])->toArray();
        $services = Service::withDescription()->cursor();
        $doctors = Doctor::withDescription();
        $reviews = Review::withDescription()->toArray();
        $evaluates = Evaluate::withDescription()->toArray();
        $evaluatesAndReviews = array_merge($evaluates, $reviews);
        $galleries = Gallery::withDescription()->toArray();
        $galleries = array_chunk($galleries, 4);
        $workHours = WorkHour::withDescription();

//        foreach ($galleries as $gallery) {
//            dump($gallery);
//        }
//
//        dd('ok');

//        dd($galleries);

        $aboutPageTitle = $pages[0]['title'];
        $aboutPageTitle1 = wordLimit($aboutPageTitle, 2, '');
        $aboutPageTitle2 = str_replace($aboutPageTitle1, '', $aboutPageTitle);

        return view($this->view.'index', get_defined_vars());
    }

    public function getGalleryMedia(Request $request)
    {
        if ($request->ajax()){
            $type = $request->type == 'all' ? null : $request->type;
            $galleries = Gallery::withDescription($type)->toArray();
            $galleries = array_chunk($galleries, 4);
            return view($this->view.'get_gallery_media', get_defined_vars());
        }
    }

    public function storeDeviceToken(Request $request)
    {
        if ($request->ajax() && !$request->isMethod('GET')){
            $token = $request->device_token;
            $data = [
                'token' => $token,
                'platform' => 'web'
            ];
            $user = Auth::user();
            $user->update([
                'device_token' => $data
            ]);

            return ['status' => true];
        }
    }

    public function calendarApi(Request $request)
    {
        $reservation_id = Session::get('reservation_id');
        $statusMsg = '';
        $status = 'danger';
        if(isset($request->code)){

            // Get event ID from session

            if(!empty($reservation_id)){

                // Fetch event details from database
                $reservation = Reservation::find($reservation_id);
                $endTime = date("H:i:s", strtotime('+'.$reservation->durations.' minutes', strtotime($reservation->appointment_time)));

                $service = Service::find($reservation->service_id);
                $branch = Branch::find($reservation->branch_id);
                $doctor = Doctor::find($reservation->doctor_id);
                    $calendar_event = array(
                        'summary' => $service->descriptionFetch()->name,
                        'location' => $branch->descriptionFetch()->name.' - '.$branch->descriptionFetch()->address,
                        'description' => 'Dr : '.$doctor->descriptionFetch()->name .' <br> Duration : '.$reservation->durations .'minutes <br> Client : '. $reservation->name.' <br> Client E-Mail : '. $reservation->email.' <br> Client Phone : '. $reservation->phone
                    );

                    $event_datetime = array(
                        'event_date' => $reservation->appointment_date,
                        'start_time' => $reservation->appointment_time,
                        'end_time' => $endTime
                    );

                    // Get the access token
                    $access_token_sess = $request['google_access_token'];
                    if(!empty($access_token_sess)){
                        $access_token = $access_token_sess;
                    }else{
                        $data = GoogleCalenderApi::GetAccessToken(env('GOOGLE_CLIENT_ID'), env('REDIRECT_URI'), env('GOOGLE_CLIENT_SECRET'), $request->code);

                        $access_token = $data['access_token'];
                    }

                    if(!empty($access_token)){

                            // Get the user's calendar timezone
                            $user_timezone = GoogleCalenderApi::GetUserCalendarTimezone($access_token);

                            // Create an event on the primary calendar
                            $google_event_id = GoogleCalenderApi::CreateCalendarEvent($access_token, 'primary', $calendar_event, 0, $event_datetime, $user_timezone);
                            
                            $reservation->update(['updated_calendar'=>date('Y-m-d H:i:s')]);
                            //echo json_encode([ 'event_id' => $event_id ]);

                            if($google_event_id){
                                // Update google event reference in the database
                                // $reservation->update(['google_calendar_event_id'=>$google_event_id]);

                                // unset($_SESSION['last_event_id']);
                                // unset($_SESSION['google_access_token']);


                            }

                    }else{
                        $statusMsg = 'Failed to fetch access token!';
                    }

            }else{
                $statusMsg = 'Event reference not found!';
            }
            
            if(!\Auth::user())
            {
                return redirect('/')->with('success','success');
            }
            else
            {
                return redirect('/admin/reservations/'.$reservation->id.'/edit')->with('success','success');
            }
        }
    }


}
