<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Page;
use Illuminate\View\View;

class AboutUsController extends Controller
{

    private $view = 'web.about_us.';
    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {

        $title = __('main.about_center');
        $pages = Page::withDescription([1,2,3,4])->toArray();
        $aboutPage = $pages[0];
        $messagePage = $pages[1];
        $goalPage = $pages[2];
        $visionPage = $pages[3];

        $aboutPageTitle1 = wordLimit($aboutPage['title'], 2, '');
        $aboutPageTitle2 = str_replace($aboutPageTitle1, '', $aboutPage['title']);
        $aboutPagePoints = $aboutPage['meta']['points'] ?? [];

        return view($this->view.'index', get_defined_vars());
    }
}
