<?php

namespace App\Http\Controllers\Admin;

use App\Module;
use App\Setting;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;
use Illuminate\Routing\Redirector;
use App\Http\Controllers\Controller;
use App\Http\Requests\ModuleRequest;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\SettingRequest;
use Illuminate\Http\RedirectResponse;

class SettingController extends Controller
{
    /** Redirect to this path after each operation success*/
    private $redirectSuccessPath = '/admin/settings';
    /** View folder */
    private $viewDirectory = 'admin.settings.';

    public function __construct()
    {
        $this->redirectSuccessPath = getCurrentLocale().$this->redirectSuccessPath;
    }

    /**
     * Display a listing of the resource.
     * @return View
     */
    public function index() :View
    {
        $head = metaFields('settings', 'edit', getCurrentLocale()) ?? __('settings.edit');
        $title = $head;

        $settingsAction= route('settings.store');
        $modulesAction= route('settings.modules');
        $settings = Setting::cursor();
        $modules = Module::where('deleted_at', null)->cursor();

        if(count($settings) > 0){
            $head = metaFields('settings', 'edit', getCurrentLocale()) ?? __('settings.edit');
            foreach ($settings as $setting) {
                $settings->{$setting['key']} = $setting['value'];
            }
        } else {
            $settings = null;
        }

//        dd($settings->meta_description_en);

        return view($this->viewDirectory.'form', get_defined_vars());
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param SettingRequest $settingRequest
     * @return JsonResponse
     */
    public function store(SettingRequest $settingRequest) :JsonResponse
    {
        $this->saveData($settingRequest);
        return response()->json(['message' => __('dashboard.saveDone')]);
//        return redirect($this->redirectSuccessPath)->with('message', __('dashboard.saveDone'));
    }

    /**
     * Store modules metas in modules table.
     *
     * @param ModuleRequest $moduleRequest
     * @return JsonResponse
     */
    public function modules(ModuleRequest $moduleRequest) :JsonResponse
    {
        $fields = $moduleRequest->fields;
        $moduleName = $moduleRequest->module_name;

        $data = array_merge_recursive($moduleName, $fields);

        foreach ($data as $path => $field) {
            Module::where('path', $path)->update([
                'meta' => $field
            ]);
        }

        return response()->json(['message' => __('dashboard.saveDone')]);

//        return redirect($this->redirectSuccessPath)->with('message', __('dashboard.saveDone'));
    }


    /**
     * Handle Save form data
     *
     * @param SettingRequest $request
     * @return void
     */

    private function saveData(SettingRequest $request):void
    {
        $data = $request->all();
        $userRole = Auth::user()->role;

        !$request->has('website_disable') && $userRole == 'super_admin' ? $data['website_disable'] = 0 : 1;
        !$request->has('dashboard_disable') && $userRole == 'super_admin' ? $data['dashboard_disable'] = 0 : 1;

        if ($request->has('update')){
            foreach ($data as $key => $value) {
                Setting::where('key', $key)->update([
                    'value' => $value
                ]);
            }
        } else {
            foreach ($data as $key => $value) {
                Setting::create([
                    'key' => $key,
                    'value' => $value,
                ]);
            }
        }
    }

}
