<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Career;
use Illuminate\Contracts\View\Factory;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

/**
 * @property array weekDates
 */
class DashboardController extends Controller
{

    private $months = [];
    private $monthByNumbers = [];
    private $monthByNames = [];
    private $translatedMonths = [];

    public function __construct()
    {
        $date = \Illuminate\Support\Carbon::make(date('Y').'-12-1');
        $months = [];
        $monthByNumbers = [];
        $monthByNames = [];
        $translatedMonths = [];

        for ($i = 1; $i <= 12; $i++){
            $x = $date->addMonth();
            $month = $x->englishMonth;
            $months[] = $month;
            $monthByNumbers[] = $i;
            $monthByNames[$i] = $x->englishMonth;
            $translatedMonths[$i] = $x->getTranslatedMonthName();
        }

        $this->months = $months;
        $this->monthByNumbers = $monthByNumbers;
        $this->monthByNames = $monthByNames;
        $this->translatedMonths = $translatedMonths;

    }

    /**
     * Show the stats of the website.
     * @return Factory|View
     */

    public function index() :View
    {
        $title = __('dashboard.dashboard');

        $months = json_encode($this->months);

        $startYear = Carbon::now()->addYears(-7);
        $lastYear = Carbon::now();

        $startMonth = Carbon::now()->addMonths(-7);
        $lastMonth = Carbon::now();

        $startWeek = Carbon::now()->addWeeks(-7);
        $lastWeek = Carbon::now();

        /*********************************************
         * Users visits block
         **********************************************/
        $yearsData = [];
        $yearsAxis = [];
        $monthsData = [];
        $monthsAxis = [];
        $weeksData = [];
        $weeksAxis = [];

        $yearVisitors = DB::table('website_visitors')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startYear, $lastYear])
            ->selectSub("YEAR(created_at)", 'yearsCount')
            ->get()->groupBy('yearsCount')->toArray();


        foreach ($yearVisitors as $year => $yearVisitor) {
            $yearsData[] = count($yearVisitor);
            $yearsAxis[] = $year;
        }

        $yearsData = json_encode($yearsData);
        $yearsAxis = json_encode($yearsAxis);

        $monthVisitors = DB::table('website_visitors')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startMonth, $lastMonth])
            ->selectSub("MONTH(created_at)", 'monthCount')
            ->get()->groupBy('monthCount')->toArray();

        foreach ($monthVisitors as $monthNumber => $monthVisitor) {
            $monthsData[] = count($monthVisitor);
            $monthsAxis[] = $this->translatedMonths[$monthNumber];
        }


        $monthsData = json_encode($monthsData);
        $monthsAxis = json_encode($monthsAxis);


        $weekVisitors = DB::table('website_visitors')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startWeek, $lastWeek])
            ->selectSub("WEEK(created_at)", 'weekCount')
            ->get()->groupBy('weekCount')->toArray();

        foreach ($weekVisitors as $weekNumber => $weekVisitor) {
            $weeksData[] = count($weekVisitor);
            $weeksAxis[] = $weekNumber;
        }

        $weeksData = json_encode($weeksData);
        $weeksAxis = json_encode($weeksAxis);


        /*********************************************
         * Careers block
         **********************************************/

        $careersYearsData = [];
        $careersYearsAxis = [];
        $careersMonthsData = [];
        $careersMonthsAxis = [];
        $careersWeeksData = [];
        $careersWeeksAxis = [];

        $yearCareers = DB::table('careers')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startYear, $lastYear])
            ->selectSub("YEAR(created_at)", 'yearsCount')
            ->get()->groupBy('yearsCount')->toArray();

        foreach ($yearCareers as $year => $yearCareer) {
            $careersYearsData[] = count($yearCareer);
            $careersYearsAxis[] = $year;
        }

        $careersYearsData = json_encode($careersYearsData);
        $careersYearsAxis = json_encode($careersYearsAxis);

        $monthCareers = DB::table('careers')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startMonth, $lastMonth])
            ->selectSub("MONTH(created_at)", 'monthCount')
            ->get()->groupBy('monthCount')->toArray();

        foreach ($monthCareers as $monthNumber => $monthCareer) {
            $careersMonthsData[] = count($monthCareer);
            $careersMonthsAxis[] = $this->translatedMonths[$monthNumber];
        }


        $careersMonthsData = json_encode($careersMonthsData);
        $careersMonthsAxis = json_encode($careersMonthsAxis);


        $weekCareers = DB::table('careers')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startWeek, $lastWeek])
            ->selectSub("WEEK(created_at)", 'weekCount')
            ->get()->groupBy('weekCount')->toArray();

        foreach ($weekCareers as $weekNumber => $weekCareer) {
            $careersWeeksData[] = count($weekCareer);
            $careersWeeksAxis[] = $weekNumber;
        }

        $careersWeeksData = json_encode($careersWeeksData);
        $careersWeeksAxis = json_encode($careersWeeksAxis);

        /*********************************************
         * Careers applications block
         **********************************************/

        $careerApplicationsYearsData = [];
        $careerApplicationsYearsAxis = [];
        $careerApplicationsMonthsData = [];
        $careerApplicationsMonthsAxis = [];
        $careerApplicationsWeeksData = [];
        $careerApplicationsWeeksAxis = [];

        $yearCareerApplications = DB::table('career_applications')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startYear, $lastYear])
            ->selectSub("YEAR(created_at)", 'yearsCount')
            ->get()->groupBy('yearsCount')->toArray();

        foreach ($yearCareerApplications as $year => $yearCareerApplication) {
            $careerApplicationsYearsData[] = count($yearCareerApplication);
            $careerApplicationsYearsAxis[] = $year;
        }

        $careerApplicationsYearsData = json_encode($careerApplicationsYearsData);
        $careerApplicationsYearsAxis = json_encode($careerApplicationsYearsAxis);

        $monthCareerApplications = DB::table('career_applications')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startMonth, $lastMonth])
            ->selectSub("MONTH(created_at)", 'monthCount')
            ->get()->groupBy('monthCount')->toArray();

        foreach ($monthCareerApplications as $monthNumber => $monthCareerApplication) {
            $careerApplicationsMonthsData[] = count($monthCareerApplication);
            $careerApplicationsMonthsAxis[] = $this->translatedMonths[$monthNumber];
        }


        $careerApplicationsMonthsData = json_encode($careerApplicationsMonthsData);
        $careerApplicationsMonthsAxis = json_encode($careerApplicationsMonthsAxis);


        $weekCareerApplications = DB::table('career_applications')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startWeek, $lastWeek])
            ->selectSub("WEEK(created_at)", 'weekCount')
            ->get()->groupBy('weekCount')->toArray();

        foreach ($weekCareerApplications as $weekNumber => $weekCareerApplication) {
            $careerApplicationsWeeksData[] = count($weekCareerApplication);
            $careerApplicationsWeeksAxis[] = $weekNumber;
        }

        $careerApplicationsWeeksData = json_encode($careerApplicationsWeeksData);
        $careerApplicationsWeeksAxis = json_encode($careerApplicationsWeeksAxis);


//        $prevYear = Carbon::now()->addYears(-1)->format('Y-m-d');
//        $nextYear = Carbon::now()->format('Y-m-d');
//
//        $prevMonth = Carbon::now()->addMonths(-1)->format('Y-m-d');
//        $nextMonth = Carbon::now()->format('Y-m-d');
//
//        $prevWeek = Carbon::now()->addWeeks(-1)->format('Y-m-d');
//        $nextWeek = Carbon::now()->format('Y-m-d');
//
//
//        $thisYearVisitors = DB::table('website_visitors')->whereBetween('created_at', [$prevYear, $nextYear])->count();
//        $thisMonthVisitors = DB::table('website_visitors')->whereBetween('created_at', [$prevMonth, $nextMonth])->count();
//
//        $thisWeekVisitors = DB::table('website_visitors')->whereBetween('created_at', [$prevWeek, $nextWeek])->count();
//        $thisDayVisitors = DB::table('website_visitors')->whereDate('created_at', date('Y-m-d'))->count();

//        $thisYearCareers = Career::whereBetween('created_at', [$prevYear, $nextYear])->count();
//        $thisMonthCareers = Career::whereBetween('created_at', [$prevMonth, $nextMonth])->count();
//        $thisWeekCareers = Career::whereBetween('created_at', [$prevWeek, $nextWeek])->count();
//        $thisDayCareers = Career::whereDate('created_at', date('Y-m-d'))->count();



        return view('admin.index', get_defined_vars());
    }
}
