<?php

namespace App\Http\Controllers\API;


use App\Branch;
use App\Gallery;
use App\Http\Requests\API\VisitorMessageRequest;
use App\Http\Resources\BranchResource;
use App\Http\Resources\ContactUsResource;
use App\Http\Resources\EvacuationResponsibilatyResource;
use App\Http\Resources\GalleryResource;
use App\Http\Resources\GoalResource;
use App\Http\Resources\IntroScreensResource;
use App\Http\Resources\MessageResource;
use App\Helpers\ImageHelper;
use App\Http\Resources\NotificationResource;
use App\Http\Resources\TermsConditionsResource;
use App\Http\Resources\VisionResource;
use App\Http\Resources\WorkHoursResource;
use App\Page;
use App\User;
use App\UsersNotification;
use App\VisitorMessage;
use App\WorkHour;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\AboutsResource;
use App\Http\Resources\LanguagesResource;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{

    /**
     * Site information like logo, about us, terms, etc...
     * @return JsonResponse
     */
    public function infoCollection() :JsonResponse
    {
        $logo = settings('website_logo') ?? 'assets/web/images/logo.png';
        $logo = ImageHelper::getFullPath($logo);
        $map = settings('site_map');
        $language = languages();
        $pages = Page::withDescription([1,2,3,4,5,6,8,9,10]);
        $workHours = WorkHour::withDescription();

        $local = getCurrentLocale();

        return response()->json([
            'message' => '',
            'data' => [
                'site_name' => settings('website_name_'.$local),
                'site_address' => settings('site_address_'.$local),
                'site_email' => settings('site_email'),
                'site_phone' => settings('site_phone'),
                'facebook' => settings('facebook'),
                'twitter' => settings('twitter'),
                'instagram' => settings('instagram'),
                'linkedin' => settings('linkedin'),
                'snapchat' => settings('snapchat'),
                'google_play_link' => settings('google_play_link'),
                'apple_store_link' => settings('apple_store_link'),
                'android_version' => settings('android_version'),
                'ios_version' => settings('ios_version'),
                'logo' => $logo,
                'site_map' => $map,
                'languages' => LanguagesResource::collection($language),
                'about' => AboutsResource::make($pages[0]),
                'vision' => VisionResource::make($pages[1]),
                'message' => MessageResource::make($pages[2]),
                'goal' => GoalResource::make($pages[3]),
                'terms_conditions' => TermsConditionsResource::make($pages[4]),
                'evacuation_responsibilaty' => EvacuationResponsibilatyResource::make($pages[5]),
                'intro_1' => IntroScreensResource::make($pages[6]),
                'intro_2' => IntroScreensResource::make($pages[7]),
                'intro_3' => IntroScreensResource::make($pages[8]),
                'work_hours' => WorkHoursResource::make($workHours),
            ]
        ], 200);

    }


    /**
     * Get branches
     * @return JsonResponse
     */
    public function branches() :JsonResponse
    {
        $branches = Branch::withDescription();
        $data = BranchResource::collection($branches);
        return response()->json(['message' => '', 'data' => $data], 200);
    }

    /**
     * Get galleries
     * @return JsonResponse
     */
    public function galleries() :JsonResponse
    {
        $galleries = Gallery::withDescription();
        $galleriesGroups = [];
        $data = GalleryResource::collection($galleries);
        foreach ($data as $item) {
            $galleriesGroups[$item->type][] = $item;
        }
        return response()->json(['message' => '', 'data' => $galleriesGroups], 200);
    }



    /**
     * Send visitor message
     * @param VisitorMessageRequest $request
     * @return JsonResponse
     */
    public function contactUs(VisitorMessageRequest $request) :JsonResponse
    {
        $data = $request->all();
//        $data['phone'] = $request->code.$request->phone;
        $contactUs = VisitorMessage::create($data);
        return response()->json(['message' => __('visitorMessages.message_success'), 'data' => ContactUsResource::make($contactUs)], 200);
    }


    public function notifications(Request $request)
    {
        $user = User::where('device_info->device_id', $request->device_id)->first();

        $notifications = UsersNotification::where('created_at', '>=', date('Y-m-d', strtotime($user->created_at)))->cursor();
        $data = NotificationResource::collection($notifications);
        return response()->json(['message' => null, 'data' => $data], 200);
    }

    /**
     * Store device id and device token
     * @param Request $request
     * @return JsonResponse
     */
    public function storeDeviceToken(Request $request)
    {
        // Device id (device_id) append to request in SecretTokenMiddleware
        // Device token (device_token) append to request in SecretTokenMiddleware
        // local append to request in SecretTokenMiddleware
        $deviceId = $request->device_id;
        $deviceToken = $request->device_token;
        $local = $request->local;

        $data = [
            'device_id' => $deviceId,
            'device_token' => $deviceToken,
            'platform' => null,
        ];

        User::updateOrCreate(
            ['device_info->device_id' => $deviceId],
            ['device_info' => $data, 'role' => 'user', 'lang' => $local]
        );
        return response()->json(['message' => null, 'data' => null], 200);
    }
}
