<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property mixed id
 * @mixin Builder
 */
class Gallery extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'type',
        'image',
        'video',
        'video_url',
    ];


    public static function withDescription($type = null)
    {
        $langId = currentLanguage()->id;
        $query = self::join('gallery_descriptions as galleryDesc', 'galleryDesc.gallery_id', 'galleries.id')
            ->where('galleryDesc.language_id', $langId);


        if ($type){
            $query->where('galleries.type', $type);
        }

        $query->select([
            'galleries.id',
            'galleries.type',
            'galleries.image',
            'galleries.video_url',
            'galleries.video',
            'galleryDesc.title'
        ]);

        return $query->get();
    }

}
