<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Evaluate
 * @package App
 * @mixin Builder
 */
class Evaluate extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'reservation_id',
        'service_id',
        'appointment_date',
        'appointment_time',
        'rate',
        'comment',
        'status',
    ];

    public static function withDescription()
    {
        $query = self::where('status', 1)
            ->orderByDesc('id')->select([
            'rate',
            'name',
            'comment',
        ]);

        return $query->cursor();
    }

}
