<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Doctor
 * @package App
 * @mixin Builder
 */
class Doctor extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'service_ids',
        'image',
    ];

    protected $casts = [
        'service_ids' => 'array'
    ];


    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(DoctorDescription::class);
    }
    public function descriptionFetch($language_id= null)
    {

        if ($language_id) {
            $data = $this->hasMany(DoctorDescription::class)->where('language_id', $language_id)->first();
            if(!$data){
                $data = $this->hasMany(DoctorDescription::class)->first();
            }

            return $data;
        }
        $data = $this->hasMany(DoctorDescription::class)->where('language_id', currentLanguage()['id'])->first();
        return $data;
    }

    /**
     * Get description of current language for pages
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(DoctorDescription::class)->where('language_id', currentLanguage()->id);
    }

    public static function withDescription($ids = [], $hasRelation = false, $serviceId = null, $randomOrder = false)
    {
        $query = self::join('doctor_descriptions as doctorDesc', 'doctorDesc.doctor_id', 'doctors.id')
            ->where('doctorDesc.language_id', currentLanguage()->id);

        if (count($ids)){
            $query->whereIn('doctors.id', $ids);
        }

        if ($hasRelation){
            $query->whereHas($hasRelation);
        }

        if ($randomOrder){
            $query->inRandomOrder();
        }

        if ($serviceId){
            $query->whereJsonContains('doctors.service_ids', "$serviceId");
        }

        $query->select([
            'doctors.id',
            'doctors.service_ids',
            'doctors.image',
            'doctorDesc.name',
            'doctorDesc.specialist',
        ]);

        return $query->get();
    }

    public function appointments()
    {
        return $this->hasMany(Appointment::class);
    }

}
