<?php

namespace App\Console;

use App\Console\Commands\AppointmentReminder;
use App\Console\Commands\SendEvaluateLink;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        AppointmentReminder::class,
        SendEvaluateLink::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        Log::info('Task schedule run successfully from kernel');
//        $schedule->call('App\Http\Controllers\Web\TaskScheduleController@appointmentReminder')->everyMinute();
        $schedule->command('appointment:reminder')->everyMinute();
        $schedule->command('evaluatelink:send')->everyMinute();
//                $schedule->call('App\Http\Controllers\Web\TaskScheduleController@sendEvaluateLink')->everyMinute();

        // $schedule->command('inspire')->hourly();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
