<?php

namespace App\Console\Commands;

use App\Jobs\SendBookingMessageJob;
use App\Reservation;
use Illuminate\Console\Command;
use Illuminate\Support\Carbon;

class SendEvaluateLink extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'evaluatelink:send';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $langId = currentLanguage()->id;
        $reminderTimeStart = Carbon::now()->addHours(-2)->format('H:i');
        $reminderTimeEnd = Carbon::now()->format('H:i');
        $reminderDate = Carbon::now()->format('Y-m-d');
        $reservations = Reservation::where('reservations.status', '=', 'confirmed')
            ->whereDate('reservations.appointment_date', $reminderDate)
            ->whereBetween('reservations.appointment_time', [$reminderTimeStart, $reminderTimeEnd])

            ->join('doctors', 'doctors.id', 'reservations.doctor_id')
            ->join('doctor_descriptions AS dDesc', 'doctors.id', 'dDesc.doctor_id')
            ->where('dDesc.language_id', $langId)

            ->select([
                'reservations.id',
                'reservations.name',
                'reservations.email',
                'reservations.phone',
                'reservations.evaluate_token',
                'dDesc.name as doctor_name',
            ])->cursor();


        foreach ($reservations as $reservation) {
            $message = __('reservations.appointment_msg_status_4');
            $name = $reservation->name;
            $doctorName = $reservation->doctor_name;
//            $link = route('booking.evaluate', [$reservation->id, $reservation->evaluate_token]);
            $link = request()->root().'/booking/evaluate/'.$reservation->id.'/'.$reservation->evaluate_token;
            $message = str_replace_array('@@', [$name, $doctorName, $link], $message);

//            try{
//                Sms::send($reservation->phone, $message);
//            } catch (Exception $exception){
//                return ['errors' => __('members.sms_error')];
//            }

            try{
                $data = [
                    'subject' => __('reservations.reservation_evaluate_msg'),
                    'message' => $message,
                    'email' => $reservation->email
                ];
                SendBookingMessageJob::dispatch($data, 'web.bookings.emails.send_email');

            } catch (\Exception $e){}
        }
    }

}
