<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Branch
 * @package App
 * @mixin Builder
 */
class Branch extends Model
{
    use SoftDeletes;

    protected $fillable = ['phone', 'map'];


    /**
     * Return current descriptions of article
     * @return HasOne
     */
    public function currentDescription() : HasOne
    {
        return $this->hasOne(BranchDescription::class)->where('language_id', currentLanguage()->id);
    }

    /**
     * Return descriptions for article
     * @return HasMany
     */
    public function descriptions() : HasMany
    {
        return $this->hasMany(BranchDescription::class);
    }

    public function descriptionFetch($language_id= null)
    {
        
        if ($language_id) {
            $data = $this->hasMany(BranchDescription::class)->where('language_id', $language_id)->first();
            if(!$data){
                $data = $this->hasMany(BranchDescription::class)->first();
            }
            
            return $data;
        }
        $data = $this->hasMany(BranchDescription::class)->where('language_id', currentLanguage()['id'])->first();
        return $data;
    }
    public static function withDescription($ids = [], $name = null)
    {
        $query = self::join('branch_descriptions as branchDesc', 'branchDesc.branch_id', 'branches.id')
            ->where('branchDesc.language_id', currentLanguage()->id);

        if (count($ids)){
            $query->whereIn('branches.id', $ids);
        }

        if ($name){
            $query->where('branchDesc.name', 'LIKE',  "%$name%");
        }

        $query->select(['branches.id', 'branches.phone', 'branches.map',  'branchDesc.name', 'branchDesc.address']);

        return $query->cursor();
    }

}
