<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ArticleDescription extends Model
{
    public $timestamps = false;

    protected $fillable = [
        'title',
        'description',
        'article_id',
        'language_id',
    ];


    /**
     * Return article for description
     * @return BelongsTo
     */
    public function article() :BelongsTo
    {
        return $this->belongsTo(Article::class);
    }
}
