<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Appointment
 * @package App
 * @mixin Builder
 */
class Appointment extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'service_id',
        'doctor_id',
        'doctor_start_shift',
        'doctor_end_shift',
        'appointment_date',
        'appointment_date_to_text',
    ];

    public function service()
    {
        return $this->belongsTo(Service::class);
    }

    public function doctor()
    {
        return $this->belongsTo(Doctor::class);
    }

    public function appointmentTimes()
    {
        return $this->hasMany(AppointmentTime::class);
    }
}
