<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Slider
 * @package App
 * @mixin Builder
 */
class AppSlider extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'type',
        'service_id',
        'image',
        'url',
    ];


    public static function withDescription($ids = [], $notIn = [])
    {
        $query = self::join('app_slider_descriptions as asDesc', 'asDesc.app_slider_id', 'app_sliders.id')
            ->where('asDesc.language_id', currentLanguage()->id);

        if (count($ids)){
            $query->whereIn('app_sliders.id', $ids);
        }

        if (count($notIn)){
            $query->whereNotIn('app_sliders.id', $notIn);
        }

        $query->select(['app_sliders.*', 'asDesc.title',  'asDesc.description']);

        return count($ids) == 1 ? $query->first() : $query->cursor();
    }

}
